# Gitaly Team specific onboarding

Welcome to [Gitaly Team](https://about.gitlab.com/handbook/engineering/development/enablement/systems/gitaly/)!!

The following items are the team-specific extension of your onboarding issue.
Please complete all but the "Reading material" section in your first few working days.

- Join Slack channels:
  - [ ] [#gitaly-lounge](https://gitlab.slack.com/archives/gitaly-lounge) (internal team affairs, generic informal chat)
  - [ ] [#g_gitaly](https://gitlab.slack.com/archives/g_gitaly) (important communication also outside the team, alerts on blocked [releases](../../doc/release.md#why-do-pipeline-failures-occur))
  - [ ] [#git-core](https://gitlab.slack.com/archives/git-core) (conversations re git itself)
  - [ ] [#s_enablement](https://gitlab.slack.com/archives/s_enablement) (section-wide communication)
  - [ ] [#gitaly-alerts](https://gitlab.slack.com/archives/gitaly-alerts) (Alerts for Gitaly pipeline failures)
  - [ ] [#gitaly-deployments](https://gitlab.slack.com/archives/gitaly-deployments) (Notifications for Gitaly deployments)
- Ask your manager or your mentor in order to:
  - [ ] get Maintainer access to the [@gl-gitaly](https://gitlab.com/groups/gl-gitaly/-/group_members) group
  - [ ] get Maintainer access to the [@gl-gitaly](https://ops.gitlab.net/groups/gl-gitaly/-/group_members) group on ops.gitlab.com
  - [ ] be added to the weekly discussion sessions and [async news doc](https://docs.google.com/document/d/1k1hY0ZdeFUnSqF6GUToFaJEtVIN_SjWeaRdx1V0i25E/edit)
  - [ ] be added to [Geekbot](https://app.geekbot.com/dashboard) for daily Slack standup updates
  - [ ] get Maintainer access to the [Gitaly Retrospective](https://gitlab.com/gl-retrospectives/enablement-section/gitaly) respository
  - [ ] get access to the [Gitaly Group calendar](https://calendar.google.com/calendar/embed?src=gitlab.com_mc911ncuk38bfngud133tjb4m8%40group.calendar.google.com&ctz=Europe%2FZurich), then add it by clicking [here](https://calendar.google.com/calendar/u/0?cid=Z2l0bGFiLmNvbV9tYzkxMW5jdWszOGJmbmd1ZDEzM3RqYjRtOEBncm91cC5jYWxlbmRhci5nb29nbGUuY29t)
- Acquire necessary access: a Role Based Access Request should have been opened for you based on [this template](https://gitlab.com/gitlab-com/team-member-epics/access-requests/-/blob/master/.gitlab/issue_templates/role_baseline_access_request_tasks/department_internal_infrastructure/role_backend_engineer_gitaly.md?ref_type=heads).
  - [ ] If that's not the case, let a manager know and open one following [these instructions](https://internal.gitlab.com/handbook/it/end-user-services/access-request/baseline-entitlements/#how-can-i-create-a-new-ar-using-a-baseline-template).
  - [ ] Complete the `Team Member Self Service` section of that issue, and note what you're getting access to.
- If transferring from another team within GitLab:
  - [ ] update your [Team page entry](https://about.gitlab.com/handbook/git-page-update/#12-add-yourself-to-the-team-page)
  - [ ] update your Slack profile ("What I do")
  - [ ] update your Zoom title
- Integrate your PTO with the Gitaly Team Calendar
  - [ ]  [follow these instructions](https://about.gitlab.com/handbook/people-group/engineering/team-pto-calendar/#steps), and use `gitlab.com_mc911ncuk38bfngud133tjb4m8@group.calendar.google.com` as the Calendar ID.
- Reading material
  - [ ] check out the [README](https://gitlab.com/gitlab-org/gitaly/-/blob/master/README.md) at https://gitlab.com/gitlab-org/gitaly, without getting lost in too much detail
  - [ ] visit the [Gitaly Training & Resources Youtube channel](https://youtube.com/playlist?list=PL05JrBw4t0KqPMCB7xW1ExIRp6YuD_7_N) for videos on how Gitaly works.
  - [ ] checkout the Gitaly doc [README](https://gitlab.com/gitlab-org/gitaly/-/blob/master/doc/README.md)
  - [ ] familiarize yourself with the [Merge request workflow](https://docs.gitlab.com/ee/development/contributing/merge_request_workflow.html) specific to working _on_ GitLab (the whole page)
  - [ ] check out the [team page](https://handbook.gitlab.com/handbook/engineering/infrastructure-platforms/data-access/gitaly/)
    - [ ] for day-to-day work, get familiar with how we [schedule work](https://handbook.gitlab.com/handbook/engineering/infrastructure-platforms/data-access/gitaly/#working-with-product). It may be useful to bookmark the [Gitaly ongoing work issue board](https://gitlab.com/groups/gitlab-org/-/boards/1140874?label_name%5B%5D=group%3A%3Agitaly&milestone_title=Upcoming)
    - [ ] for the big picture, see the team [vision and roadmap](https://handbook.gitlab.com/handbook/engineering/infrastructure-platforms/data-access/gitaly/#roadmap) (click through on the links)
  - [ ] create an MR in the [chef-repo](https://gitlab.com/gitlab-com/gl-infra/chef-repo/) to add a [data bag](https://gitlab.com/gitlab-com/gl-infra/chef-repo/-/blob/master/doc/user-administration.md#add-a-new-developer)
    for yourself to create your user on production machines. Be sure to include
    `"gitaly-team"` under the `groups` field.

/confidential
/assign me
/cc @jcaigitlab
